/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LookupChain {
    protected static LookupChain instance = null;
    protected Map<String, List<LookupCallback>> lookupCallbacks = new ConcurrentHashMap<String, List<LookupCallback>>();

    static {
        instance = new LookupChain();
    }

    public void addLookup(String lookupName, LookupCallback c) {
        if (!this.lookupCallbacks.containsKey(lookupName)) {
            this.lookupCallbacks.put(lookupName, new ArrayList());
        }
        this.lookupCallbacks.get(lookupName).add(c);
    }

    public static String lookupString(String filterName, String val) {
        Object r = LookupChain.getInstance().lookup(filterName, val);
        if (r == null) {
            return val;
        }
        if (r instanceof String) {
            return (String)r;
        }
        return r.toString();
    }

    public Object lookup(String filterName, Object val) {
        List<LookupCallback> list = this.lookupCallbacks.get(filterName);
        if (list == null) {
            return null;
        }
        int x = 0;
        while (x < list.size()) {
            Object v2 = list.get(x).lookup(val);
            if (v2 != null) {
                return v2;
            }
            ++x;
        }
        return null;
    }

    public static LookupChain getInstance() {
        return instance;
    }

    public static interface LookupCallback {
        public Object lookup(Object var1);
    }
}

